// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : EntityFish.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "EntityFish.h"
#include "EntityPlayer.h"
#include "EntityParticle.h"
#include "Level.h"




EntityFish::EntityFish( Dobbs::EntityTypes EType ) 
{

  m_Type = EType;
  m_CanBeCarried    = true;
  m_Floating        = true;
  m_InsideWater     = true;

  m_DisplayOffset.x = 24;
  m_DisplayOffset.y = 24;

  m_JumpStartY = 0.0f;
  m_JumpDelay  = 0.0f;

  SetRect( &m_CollisionRect, -18, -18, 18, 18 );

  if ( EType == Dobbs::ENTITY_TYPE_FISH_L )
  {
    SetFrame( Dobbs::ANIM_FISH_SWIM_L );
  }
  else
  {
    SetFrame( Dobbs::ANIM_FISH_SWIM_R );
  }

}



EntityFish::~EntityFish() 
{
}



void EntityFish::OnEvent( const EntityEvent Event, int Param1, int Param2, const std::string& TextParam, Entity* pEntity )
{

  switch ( Event )
  {
    case EE_BLOCKED_LEFT:
      m_Type = Dobbs::ENTITY_TYPE_FISH_R;
      SetFrame( Dobbs::ANIM_FISH_SWIM_R );
      break;
    case EE_BLOCKED_RIGHT:
      m_Type = Dobbs::ENTITY_TYPE_FISH_L;
      SetFrame( Dobbs::ANIM_FISH_SWIM_L );
      break;
    case EE_JUMP_DONE:
      SetFrame( Dobbs::ANIM_FISH_FALL );
      SetState( 2 );
      break;
  }
  Entity::OnEvent( Event, Param1, Param2, TextParam, pEntity );

}



void EntityFish::Splash()
{

  for ( int i = 0; i < 10; ++i )
  {
    EntityParticle* pExplosion = m_pLevel->SpawnParticle( Dobbs::SPLASH, GetX(), GetY() + 16 );
    float   DX = rand() % 161 - 80.0f;
    float   DY = rand() % 161 - 80.0f;

    DY -= 140.0f;

    pExplosion->SetVelX( DX );
    pExplosion->SetVelY( DY );
    pExplosion->SetLifeTime( 0.2f );
    pExplosion->SetFrame( Dobbs::ANIM_EXPLOSION_PARTICLE_SMALL );
    pExplosion->SetColor( 0x80E76E57 );
  }

}



void EntityFish::UpdateTimed( Level& aLevel, float ElapsedTime )
{

  if ( m_JumpDelay > 0.0f )
  {
    m_JumpDelay -= ElapsedTime;
    if ( m_JumpDelay <= 0.0f )
    {
      m_JumpDelay = 0.0f;
    }
  }

  Entity::UpdateTimed( aLevel, ElapsedTime );
  if ( m_State == 0 )
  {
    if ( m_Type == Dobbs::ENTITY_TYPE_FISH_L )
    {
      Move( aLevel, -120.0f * ElapsedTime, 0.0f, Dobbs::DIR_LEFT );
    }
    else
    {
      Move( aLevel, 120.0f * ElapsedTime, 0.0f, Dobbs::DIR_RIGHT );
    }
    if ( ( aLevel.m_pPlayer )
    &&   ( aLevel.m_pPlayer->GetState() == Dobbs::STATE_OK )
    &&   ( m_Y - aLevel.m_pPlayer->GetY() >= 0.0f )
    &&   ( m_Y - aLevel.m_pPlayer->GetY() < 320.0f )
    &&   ( abs( m_X - aLevel.m_pPlayer->GetX() ) <= 100.0f )
    &&   ( m_JumpDelay == 0.0f ) )
    {
      m_JumpStartY = (float)m_Y;
      m_Floating = false;
      ForceJump( aLevel, 800 );
      SetState( 1 );
      SetFrame( Dobbs::ANIM_FISH_JUMP );
    }
  }
  else if ( m_State == 1 )
  {
    Dobbs::TileType   TileWater = aLevel.TileFromLayer( 2, m_X / 32, m_Y / 32 );
    if ( ( TileWater != Dobbs::TILE_WATER_TOP )
    &&   ( TileWater != Dobbs::TILE_WATER ) )
    {
      // left water
      if ( m_InsideWater )
      {
        m_InsideWater = false;
        // Splash water
        Splash();
      }
    }
  }
  else if ( m_State == 2 )
  {
    Dobbs::TileType   TileWater = aLevel.TileFromLayer( 2, m_X / 32, m_Y / 32 );
    if ( ( TileWater == Dobbs::TILE_WATER_TOP )
    ||   ( TileWater == Dobbs::TILE_WATER ) )
    {
      if ( !m_InsideWater )
      {
        m_InsideWater = true;
        // splash water
        Splash();
      }
    }
    if ( m_Y > m_JumpStartY )
    {
      m_JumpDelay = 2.0f;
      m_JumpCount = 0;
      m_FallCount = 0;
      m_FallSpeed = 0;
      m_Floating = true;
      m_Y = (int)m_JumpStartY;
      m_InsideWater = true;
      SetState( 0 );

      if ( m_Type == Dobbs::ENTITY_TYPE_FISH_L )
      {
        SetFrame( Dobbs::ANIM_FISH_SWIM_L );
      }
      else
      {
        SetFrame( Dobbs::ANIM_FISH_SWIM_R );
      }
    }
  }

}